#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_Laboratory : BaseTest 
	{
		private ArrayList _tests;
		private ArrayList _patients;
		private System.DateTime _startDate = System.DateTime.Now.AddYears(-100);
		private System.DateTime _endDate  = System.DateTime.Now.AddYears(1);
		
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
			
			if (this.RefreshData)
			{
				this._tests = new ArrayList();
				this._patients = new ArrayList();

				this._tests.Add("3");
				this._tests.Add("4");
				
				this._patients.Add("378793");
				
				this.RefreshData = false;
			}
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void GetLaboratoryTestData_Pass()
		{
			DataTable dtTest = DAL.VAL.LaboratoryTest.GetLaboratoryTestData( "HEM" );

			Assert.IsTrue(dtTest.Rows.Count > 0);
			Assert.IsTrue(dtTest.Columns.Count == 3);
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void GetLaboratoryTestData_Fail()
		{
			DAL.VAL.LaboratoryTest.GetLaboratoryTestData(null);
		}

		[Test]
		public void GetLaboratoryTestResults_Pass()
		{
			DataSet dsTest = DAL.VAL.LaboratoryTest.GetLaboratoryTestResults(this._startDate, this._endDate, null, this._tests, this._patients);

			Assert.IsTrue(dsTest.Tables.Count > 0, "Tables.Count:" + dsTest.Tables.Count.ToString());
			Assert.IsTrue(dsTest.Tables[0].Rows.Count > 0, "Rows.Count:" + dsTest.Tables[0].Rows.Count.ToString());
			Assert.AreEqual(6, dsTest.Tables[0].Columns.Count, "Columns Count");
        }

		[Test]
		[ExpectedException( typeof( ArgumentNullException) )]
		public void GetLaboratoryTestResults_Fail()
		{
			DAL.VAL.LaboratoryTest.GetLaboratoryTestResults(this._startDate, this._endDate, UnitTestConfig.TestDivisionCode, this._tests, new ArrayList());
		}
	}
}
#endif
